﻿using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class PATIENT_REGDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public PATIENT_REGDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public PATIENT_REG GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            PATIENT_REG objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_PATIENT_REG_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<PATIENT_REG> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<PATIENT_REG> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_PATIENT_REG_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, PATIENT_REG objSave)
        {
            Int32? objReturn = objSave.PATIENT_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_PATIENT_REG_save(
                    CURRENT_USER,
                    CURRENT_REGISTRY_ID,
                    objSave.ADDRESS_LINE1,
                    objSave.ADDRESS_LINE2,
                    objSave.ADDRESS_LINE3,
                    objSave.ADDRESS_TYPE,
                    objSave.CITY,
                    objSave.COUNTRY,
                    objSave.COUNTY,
                    objSave.DOD_PATIENT_ID,
                    objSave.HOME_PHONE,
                    objSave.LastServiceSeparationDate,
                    objSave.LIVING_ARRANGEMENT_TEXT,
                    objSave.OEF_OIF_LOCATION,
                    objSave.PATIENT_EDIPI,
                    objSave.PATIENT_ICN,
                    ref objReturn,
                    objSave.PatientICNCheckSUM,
                    objSave.POSTAL_CODE,
                    objSave.PreferredContactMethod,
                    objSave.PRIMARY_PHONE,
                    objSave.SERVICE_STATUS,
                    objSave.Snum,
                    objSave.STATE,
                    objSave.STD_COMBATLOCATION_ID,
                    objSave.STD_ETHNICITY_ID,
                    objSave.STD_GENDER_ID,
                    objSave.STD_INSTITUTION_ID,
                    objSave.STD_MARITALSTATUS_ID,
                    objSave.STD_RACE_ID,
                    objSave.STD_SERVICEBRANCH_ID,
                    objSave.VPID_NUMBER,
                    objSave.WORK_PHONE,
                    objSave.ZIP_PLUS_4);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_PATIENT_REG_delete(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
